const BROWSER_LANG=chrome.i18n.getUILanguage().toLowerCase().startsWith("zh")?"zh":"en",KEY_MAP={title:"title","login.title":"loginTitle","login.subtitle":"loginSubtitle","login.email":"loginEmail","login.password":"loginPassword","login.loginBtn":"loginLoginBtn","login.registerBtn":"loginRegisterBtn","login.browseWithoutLogin":"loginBrowseWithoutLogin","login.noAccount":"loginNoAccount","login.goToRegister":"loginGoToRegister","login.loggingIn":"loginLoggingIn","login.registering":"loginRegistering","login.loginSuccess":"loginSuccess","login.registerSuccess":"loginRegisterSuccess","login.loginFailed":"loginFailed","login.registerFailed":"loginRegisterFailed","login.invalidEmail":"loginInvalidEmail","login.passwordTooShort":"loginPasswordTooShort","login.pleaseLoginFirst":"loginPleaseLoginFirst","register.title":"registerTitle","register.subtitle":"registerSubtitle","register.passwordConfirm":"registerPasswordConfirm","register.backToLogin":"registerBackToLogin","register.hasAccount":"registerHasAccount","register.goToLogin":"registerGoToLogin",registerPasswordMismatch:"registerPasswordMismatch","header.title":"headerTitle","header.openChatGPT":"headerOpenChatGPT","header.login":"headerLogin","header.logout":"headerLogout","header.loggedInAs":"headerLoggedInAs","header.guestMode":"headerGuestMode","header.register":"headerRegister","notice.title":"noticeTitle","notice.chatgptLogin":"noticeChatgptLogin","input.title":"inputTitle","input.placeholder":"inputPlaceholder","input.addBtn":"inputAddBtn","input.clearBtn":"inputClearBtn","control.title":"controlTitle","control.startBtn":"controlStartBtn","control.pauseBtn":"controlPauseBtn","control.resumeBtn":"controlResumeBtn","control.stopBtn":"controlStopBtn","control.retryBtn":"controlRetryBtn","control.useTempChat":"controlUseTempChat","control.useTempChatHint":"controlUseTempChatHint","control.useWebSearch":"controlUseWebSearch","control.useWebSearchHint":"controlUseWebSearchHint","stats.total":"statsTotal","stats.completed":"statsCompleted","stats.success":"statsSuccess","stats.failed":"statsFailed","progress.ready":"progressReady","progress.running":"progressRunning","progress.processing":"progressProcessing","progress.paused":"progressPaused","progress.completed":"progressCompleted","log.title":"logTitle","questions.title":"questionsTitle","questions.exportBtn":"questionsExportBtn","questions.clearBtn":"questionsClearBtn","questions.question":"questionsQuestion","questions.answer":"questionsAnswer","questions.sources":"questionsSources","questions.viewAnswer":"questionsViewAnswer","questions.hideAnswer":"questionsHideAnswer","questions.noQuestions":"questionsNoQuestions","questions.addToStart":"questionsAddToStart","questions.noAnswer":"questionsNoAnswer","questions.errorInfo":"questionsErrorInfo","questions.unknownError":"questionsUnknownError","questions.status.pending":"statusPending","questions.status.processing":"statusProcessing","questions.status.completed":"statusCompleted","questions.status.failed":"statusFailed","messages.pleaseEnterQuestion":"msgPleaseEnterQuestion","messages.questionsAdded":"msgQuestionsAdded","messages.inputCleared":"msgInputCleared","messages.alreadyRunning":"msgAlreadyRunning","messages.noQuestions":"msgNoQuestions","messages.pleaseAddQuestions":"msgPleaseAddQuestions","messages.executionStarted":"msgExecutionStarted","messages.executionPaused":"msgExecutionPaused","messages.executionResumed":"msgExecutionResumed","messages.executionStopped":"msgExecutionStopped","messages.noFailedQuestions":"msgNoFailedQuestions","messages.retryingFailed":"msgRetryingFailed","messages.noResults":"msgNoResults","messages.resultsExported":"msgResultsExported","messages.pleaseStopFirst":"msgPleaseStopFirst","messages.confirmClearAll":"msgConfirmClearAll","messages.allCleared":"msgAllCleared","messages.completed":"msgCompleted","messages.failed":"msgFailed","messages.waitingNext":"msgWaitingNext","messages.allCompleted":"msgAllCompleted","messages.chatGPTOpened":"msgChatGPTOpened","messages.chatGPTOpenFailed":"msgChatGPTOpenFailed","messages.openingChatGPT":"msgOpeningChatGPT","messages.cannotOpenChatGPT":"msgCannotOpenChatGPT","messages.error":"msgError","messages.startingBatch":"msgStartingBatch","messages.foundPending":"msgFoundPending","messages.waitingPage":"msgWaitingPage","messages.startingFirst":"msgStartingFirst","messages.resetFailed":"msgResetFailed","messages.submittedWaiting":"msgSubmittedWaiting","messages.processingFailed":"msgProcessingFailed","messages.loadedQuestions":"msgLoadedQuestions","messages.loadFailed":"msgLoadFailed","messages.ready":"msgReady"};let questions=[],isRunning=!1,isPaused=!1,currentIndex=0;const questionsInput=document.getElementById("questionsInput"),addQuestionsBtn=document.getElementById("addQuestionsBtn"),clearInputBtn=document.getElementById("clearInputBtn"),startBtn=document.getElementById("startBtn"),pauseBtn=document.getElementById("pauseBtn"),resumeBtn=document.getElementById("resumeBtn"),stopBtn=document.getElementById("stopBtn"),stopBtn2=document.getElementById("stopBtn2"),retryFailedBtn=document.getElementById("retryFailedBtn"),exportBtn=document.getElementById("exportBtn"),useTempChatCheckbox=document.getElementById("useTempChatCheckbox"),useWebSearchCheckbox=document.getElementById("useWebSearchCheckbox"),clearAllBtn=document.getElementById("clearAllBtn"),progressText=document.getElementById("progressText"),progressPercent=document.getElementById("progressPercent"),idleButtons=document.getElementById("idleButtons"),runningButtons=document.getElementById("runningButtons"),pausedButtons=document.getElementById("pausedButtons"),retryButtonContainer=document.getElementById("retryButtonContainer"),questionsList=document.getElementById("questionsList"),logContainer=document.getElementById("logContainer"),totalCount=document.getElementById("totalCount"),completedCount=document.getElementById("completedCount"),successCount=document.getElementById("successCount"),failedCount=document.getElementById("failedCount"),progressFill=document.getElementById("progressFill");function setupEventListeners(){addQuestionsBtn.addEventListener("click",handleAddQuestions),clearInputBtn.addEventListener("click",handleClearInput),startBtn.addEventListener("click",handleStart),pauseBtn.addEventListener("click",handlePause),resumeBtn.addEventListener("click",handleResume),stopBtn.addEventListener("click",handleStop),stopBtn2.addEventListener("click",handleStop),retryFailedBtn.addEventListener("click",handleRetryFailed),useTempChatCheckbox.addEventListener("change",handleTempChatChange),useWebSearchCheckbox.addEventListener("change",handleWebSearchChange),exportBtn.addEventListener("click",handleExport),clearAllBtn.addEventListener("click",handleClearAll)}function t(e,t){let s,n=KEY_MAP[e];if(n||(n=e),t)if("object"!=typeof t||Array.isArray(t))s=Array.isArray(t)?chrome.i18n.getMessage(n,t.map(String)):chrome.i18n.getMessage(n,String(t));else{const e=Object.values(t);s=chrome.i18n.getMessage(n,e.map(String))}else s=chrome.i18n.getMessage(n);return s?(t&&"object"==typeof t&&!Array.isArray(t)&&(s=s.replace(/\{(\w+)\}/g,(e,s)=>void 0!==t[s]?t[s]:e)),s):e}function applyTranslations(){document.title=t("title"),document.documentElement.lang=BROWSER_LANG,document.querySelectorAll("[data-i18n]").forEach(e=>{const s=e.getAttribute("data-i18n");e.textContent=t(s)}),document.querySelectorAll("[data-i18n-placeholder]").forEach(e=>{const s=e.getAttribute("data-i18n-placeholder");e.placeholder=t(s)}),updateUI()}function generateUUID(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){const t=16*Math.random()|0;return("x"===e?t:3&t|8).toString(16)})}function handleAddQuestions(){if(!requireAuth())return;const e=questionsInput.value.trim();if(!e)return void addLog(t("messages.pleaseEnterQuestion"),"warning");const s=e.split("\n").filter(e=>e.trim());let n=0;s.forEach(e=>{const t=e.trim();t&&(questions.push({id:generateUUID(),question:t,status:"pending",answer:"",sources:[],timestamp:Date.now(),error:null}),n++)}),n>0&&(questionsInput.value="",saveQuestions(),updateUI(),addLog(`${n} ${t("messages.questionsAdded")}`,"success"))}function handleClearInput(){questionsInput.value=""}async function handleStart(){if(!requireAuth())return;if(0===questions.length)return void addLog(t("messages.noQuestions"),"warning");const e=questions.filter(e=>"pending"===e.status||"failed"===e.status);if(0===e.length)return void addLog(t("messages.noQuestions"),"warning");questions.forEach(e=>{"failed"===e.status&&(e.status="pending",e.error=null)}),saveQuestions(),updateUI();const s=useTempChatCheckbox.checked,n=useWebSearchCheckbox.checked;addLog(t("messages.openingChatGPT"),"info");try{const e=await chrome.runtime.sendMessage({type:"OPEN_CHATGPT",useTempChat:s,useWebSearch:n});if(!e.success)return void addLog(t("messages.cannotOpenChatGPT")+": "+e.error,"error")}catch(e){return void addLog(t("messages.error")+": "+e.message,"error")}isRunning=!0,isPaused=!1,currentIndex=0,updateControlButtons(),addLog(t("messages.startingBatch"),"info"),addLog(t("messages.foundPending",{count:e.length}),"info"),addLog(t("messages.waitingPage"),"info"),await sleep(3e3),addLog(t("messages.startingFirst"),"info"),processNextQuestion()}function handlePause(){isPaused=!0,updateControlButtons(),addLog(t("messages.executionPaused"),"warning")}function handleResume(){isPaused=!1,updateControlButtons(),addLog(t("messages.executionResumed"),"info"),processNextQuestion()}function handleStop(){isRunning=!1,isPaused=!1,updateControlButtons(),addLog(t("messages.executionStopped"),"warning")}function handleRetryFailed(){if(isRunning)return void addLog(t("messages.pleaseStopFirst"),"warning");const e=questions.filter(e=>"failed"===e.status);0!==e.length?(e.forEach(e=>{e.status="pending",e.error=null}),saveQuestions(),updateUI(),addLog(t("messages.resetFailed").replace("{count}",e.length),"success")):addLog(t("messages.noFailedQuestions"),"info")}async function processNextQuestion(){if(!isRunning||isPaused)return;let e=null;for(let t=currentIndex;t<questions.length;t++)if("pending"===questions[t].status){e=questions[t],currentIndex=t;break}if(!e){isRunning=!1,updateControlButtons();questions.filter(e=>"completed"===e.status).length,questions.filter(e=>"failed"===e.status).length;return void addLog(t("messages.allCompleted"),"success")}e.status="processing",saveQuestions(),updateUI();const s=e.question.substring(0,50);addLog(`[${currentIndex+1}/${questions.length}]: ${s}...`,"info");try{const s=useTempChatCheckbox.checked,n=useWebSearchCheckbox.checked,o=await chrome.runtime.sendMessage({type:"PROCESS_QUESTION",question:e.question,questionId:e.id,useTempChat:s,useWebSearch:n});if(!o||!o.success)throw new Error(o?.error||"No response from background script");addLog(t("messages.submittedWaiting"),"info")}catch(s){e.status="failed",e.error=s.message,saveQuestions(),updateUI(),addLog(t("messages.processingFailed")+": "+s.message,"error"),currentIndex++,isRunning&&!isPaused&&(await sleep(2e3),processNextQuestion())}}function handleQuestionComplete(e){const s=questions.find(t=>t.id===e.questionId);s&&"completed"!==s.status&&"failed"!==s.status&&(e.success?(s.status="completed",s.answer=e.answer,s.sources=e.sources||[],s.completedAt=Date.now(),addLog(t("messages.completed")+": "+s.question.substring(0,50)+"...","success")):(s.status="failed",s.error=e.error,s.completedAt=Date.now(),addLog(t("messages.failed")+": "+s.question.substring(0,50)+"... - "+e.error,"error")),saveQuestions(),updateUI(),currentIndex++,isRunning&&!isPaused&&(addLog(t("messages.waitingNext"),"info"),sleep(3e3).then(()=>{processNextQuestion()})))}function handleExport(){if(!requireAuth())return;if(0===questions.length)return void addLog(t("messages.noResults"),"warning");const e={exportTime:(new Date).toISOString(),totalQuestions:questions.length,completedQuestions:questions.filter(e=>"completed"===e.status).length,questions:questions.map(e=>({question:e.question,status:e.status,answer:e.answer,sources:e.sources,timestamp:e.timestamp,completedAt:e.completedAt,error:e.error}))},s=new Blob([JSON.stringify(e,null,2)],{type:"application/json"}),n=URL.createObjectURL(s),o=document.createElement("a");o.href=n,o.download=`chatgpt-answers-${Date.now()}.json`,document.body.appendChild(o),o.click(),document.body.removeChild(o),URL.revokeObjectURL(n),addLog(t("messages.resultsExported"),"success")}function handleClearAll(){isRunning?addLog("请先停止处理","warning"):confirm("确定要清空所有问题吗？")&&(questions=[],saveQuestions(),updateUI(),addLog(t("messages.allCleared"),"info"))}function updateUI(){updateStatistics(),updateQuestionsList(),updateControlButtons()}function updateStatValue(e,t){const s=parseInt(e.textContent)||0;e.textContent=t,t>s&&(e.classList.remove("updated"),e.offsetWidth,e.classList.add("updated"),setTimeout(()=>{e.classList.remove("updated")},400))}function updateStatistics(){const e=questions.length,s=questions.filter(e=>"completed"===e.status||"failed"===e.status).length,n=questions.filter(e=>"completed"===e.status).length,o=questions.filter(e=>"failed"===e.status).length,a=questions.filter(e=>"processing"===e.status).length;updateStatValue(totalCount,e),updateStatValue(completedCount,s),updateStatValue(successCount,n),updateStatValue(failedCount,o);const i=e>0?s/e*100:0;if(progressFill.style.width=i+"%",progressPercent.textContent=Math.round(i)+"%",isRunning&&a>0){const s=questions.findIndex(e=>"processing"===e.status);if(-1!==s){const n=s+1;progressText.textContent=t("progress.processing",{current:n,total:e})}else progressText.textContent=t("progress.running")}else progressText.textContent=t(isPaused?"progress.paused":e>0&&s===e?"progress.completed":"progress.ready");const r=document.querySelector(".stat-failed");r&&(0===o?r.classList.add("stat-muted"):r.classList.remove("stat-muted"))}function updateQuestionsList(){if(0===questions.length)return void(questionsList.innerHTML=`\n      <div class="empty-state">\n        <p data-i18n="questions.noQuestions">${t("questions.noQuestions")}</p>\n        <p data-i18n="questions.addToStart">${t("questions.addToStart")}</p>\n      </div>\n    `);questionsList.innerHTML="";[...questions].reverse().forEach((e,t)=>{const s=createQuestionItem(e,t);questionsList.appendChild(s)})}function createQuestionItem(e,s){const n=document.createElement("div");n.className="question-item",n.dataset.id=e.id;const o=e.status,a=t("questions.status."+e.status);let i="";if("completed"===e.status){let s="";e.sources&&e.sources.length>0&&(s=`\n        <div class="detail-section">\n          <h4>${t("questions.sources")} (${e.sources.length})</h4>\n          <ul class="sources-list">\n            ${e.sources.map(e=>`\n              <li class="source-item">\n                <div class="source-title">${escapeHtml(e.title)}</div>\n                <a href="${escapeHtml(e.url)}" target="_blank" class="source-url">${escapeHtml(e.url)}</a>\n                ${e.snippet?`<div class="source-snippet">${escapeHtml(e.snippet)}</div>`:""}\n              </li>\n            `).join("")}\n          </ul>\n        </div>\n      `),i=`\n      <div class="question-details">\n        <div class="detail-section">\n          <h4>${t("questions.question")}</h4>\n          <div class="answer-text">${escapeHtml(e.question)}</div>\n        </div>\n        <div class="detail-section">\n          <h4>${t("questions.answer")}</h4>\n          <div class="answer-text">${escapeHtml(e.answer||t("questions.noAnswer"))}</div>\n        </div>\n        ${s}\n      </div>\n    `}else"failed"===e.status&&(i=`\n      <div class="question-details">\n        <div class="detail-section">\n          <h4>${t("questions.question")}</h4>\n          <div class="answer-text">${escapeHtml(e.question)}</div>\n        </div>\n        <div class="detail-section">\n          <h4>${t("questions.errorInfo")}</h4>\n          <div class="error-text">${escapeHtml(e.error||t("questions.unknownError"))}</div>\n        </div>\n      </div>\n    `);const r=e.completedAt?new Date(e.completedAt).toLocaleString("zh-CN",{month:"2-digit",day:"2-digit",hour:"2-digit",minute:"2-digit"}):"";return n.innerHTML=`\n    <div class="question-header">\n      <span class="status-badge ${o}">${a}</span>\n      <div class="question-text" title="${escapeHtml(e.question)}">\n        ${escapeHtml(e.question)}\n      </div>\n      ${r?`<span class="question-time">${r}</span>`:""}\n    </div>\n    ${i}\n  `,n.addEventListener("click",()=>{n.classList.toggle("expanded")}),n}function updateControlButtons(){idleButtons.style.display="none",runningButtons.style.display="none",pausedButtons.style.display="none",isRunning?isPaused?pausedButtons.style.display="flex":runningButtons.style.display="flex":idleButtons.style.display="flex";questions.filter(e=>"failed"===e.status).length>0&&!isRunning?retryButtonContainer.style.display="flex":retryButtonContainer.style.display="none"}function addLog(e,t="info"){const s=document.createElement("div");s.className=`log-entry ${t}`;const n=(new Date).toLocaleTimeString();for(s.textContent=`[${n}] ${e}`,logContainer.appendChild(s),logContainer.scrollTop=logContainer.scrollHeight;logContainer.children.length>100;)logContainer.removeChild(logContainer.firstChild)}function saveQuestions(){chrome.storage.local.set({questions:questions})}function saveTempChatSetting(e){chrome.storage.local.set({useTempChat:e})}function handleTempChatChange(e){const s=e.target.checked;saveTempChatSetting(s),addLog(t(s?"msgTempChatEnabled":"msgTempChatDisabled"),"info")}async function loadQuestions(){try{const e=await chrome.storage.local.get(["questions"]);e.questions&&(questions=e.questions,updateUI(),addLog(t("messages.loadedQuestions").replace("{count}",questions.length),"info"))}catch(e){addLog(t("messages.loadFailed")+": "+e.message,"error")}}async function loadTempChatSetting(){try{const e=await chrome.storage.local.get(["useTempChat"]),t=void 0===e.useTempChat||e.useTempChat;useTempChatCheckbox.checked=t}catch(e){useTempChatCheckbox.checked=!0}}function saveWebSearchSetting(e){chrome.storage.local.set({useWebSearch:e})}function handleWebSearchChange(e){const s=e.target.checked;saveWebSearchSetting(s),addLog(t(s?"msgWebSearchEnabled":"msgWebSearchDisabled"),"info")}async function loadWebSearchSetting(){try{const e=await chrome.storage.local.get(["useWebSearch"]),t=void 0===e.useWebSearch||e.useWebSearch;useWebSearchCheckbox.checked=t}catch(e){useWebSearchCheckbox.checked=!0}}document.addEventListener("DOMContentLoaded",()=>{applyTranslations(),loadQuestions(),setupEventListeners(),updateUI()}),chrome.runtime.onMessage.addListener((e,t,s)=>{switch(e.type){case"QUESTION_COMPLETE":handleQuestionComplete(e.result),s({received:!0});break;case"UPDATE_PROGRESS":s({received:!0});break;case"LOG_MESSAGE":addLog(e.message,e.level||"info"),s({received:!0});break;default:s({received:!1})}return!0});let lastProcessedMessageTimestamp=0;function sleep(e){return new Promise(t=>setTimeout(t,e))}function escapeHtml(e){if(!e)return"";const t=document.createElement("div");return t.textContent=e,t.innerHTML}chrome.storage.onChanged.addListener((e,t)=>{if("local"===t&&e.pendingMessage){const t=e.pendingMessage.newValue;if(!t)return;if(t.timestamp&&t.timestamp<=lastProcessedMessageTimestamp)return;switch(t.timestamp&&(lastProcessedMessageTimestamp=t.timestamp),t.type){case"QUESTION_COMPLETE":handleQuestionComplete(t.result),chrome.storage.local.remove("pendingMessage");break;case"UPDATE_PROGRESS":chrome.storage.local.remove("pendingMessage");break;case"LOG_MESSAGE":addLog(t.message,t.level||"info"),chrome.storage.local.remove("pendingMessage")}}}),window.handleBackgroundMessage=function(e){chrome.runtime.onMessage.addListener(arguments[0])};class AuthManager{constructor(){this.token=null,this.email=null,this.serverUrl=null}async init(){const e=await chrome.storage.local.get(["authToken","authEmail"]);return this.token=e.authToken||null,this.email=e.authEmail||null,this.serverUrl="undefined"!=typeof CONFIG?CONFIG.DEFAULT_SERVER_URL:"http://localhost:8000",this.isAuthenticated()}isAuthenticated(){return!!this.token&&!!this.email}async login(e,t){try{const s=await fetch(`${this.serverUrl}/api/auth/login`,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify({email:e,password:t})});if(!s.ok){const e=await s.json();throw new Error(e.detail||"Login failed")}const n=await s.json();return this.token=n.access_token,this.email=e,await chrome.storage.local.set({authToken:this.token,authEmail:this.email}),!0}catch(e){throw e}}async register(e,t){try{const s=await fetch(`${this.serverUrl}/api/auth/register`,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify({email:e,password:t})});if(!s.ok){const e=await s.json();throw new Error(e.detail||"Registration failed")}return!0}catch(e){throw e}}async logout(){this.token=null,this.email=null,await chrome.storage.local.remove(["authToken","authEmail"])}async callAPI(e,t){if(!this.isAuthenticated())throw new Error("Not authenticated");try{const s=await fetch(`${this.serverUrl}${e}`,{method:"POST",headers:{"Content-Type":"application/json",Authorization:`Bearer ${this.token}`},body:JSON.stringify(t)});if(401===s.status)throw await this.logout(),new Error("Authentication expired, please login again");if(!s.ok){const e=await s.json();throw new Error(e.detail||"API call failed")}return await s.json()}catch(e){throw e}}}const authManager=new AuthManager;function showLoginModal(){document.getElementById("loginModal").style.display="block",document.getElementById("registerModal").style.display="none"}function hideLoginModal(){document.getElementById("loginModal").style.display="none"}function showRegisterModal(){document.getElementById("registerModal").style.display="block",document.getElementById("loginModal").style.display="none"}function hideRegisterModal(){document.getElementById("registerModal").style.display="none"}function updateUIForAuthState(e){const t=document.getElementById("loginStatusBtn"),s=document.getElementById("logoutBtn"),n=document.getElementById("userInfoBar"),o=document.getElementById("guestInfoBar"),a=document.getElementById("userNameShort"),i=document.getElementById("dropdownUserEmail");if(e){t.style.display="none",s.style.display="block",n.style.display="flex",o.style.display="none";const e=authManager.email.split("@")[0];a.textContent=e,i.textContent=authManager.email,enableAllButtons()}else t.style.display="block",s.style.display="none",n.style.display="none",o.style.display="block",disableAuthRequiredButtons()}function enableAllButtons(){["addQuestionsBtn","startBtn","pauseBtn","resumeBtn","stopBtn","retryFailedBtn","exportBtn","clearAllBtn"].forEach(e=>{const t=document.getElementById(e);t&&(t.disabled=!1,t.style.opacity="1",t.style.cursor="pointer")});const e=document.getElementById("questionsInput");e&&(e.disabled=!1,e.style.opacity="1"),useTempChatCheckbox&&(useTempChatCheckbox.disabled=!1,useTempChatCheckbox.style.opacity="1",useTempChatCheckbox.style.cursor="pointer"),useWebSearchCheckbox&&(useWebSearchCheckbox.disabled=!1,useWebSearchCheckbox.style.opacity="1",useWebSearchCheckbox.style.cursor="pointer")}function disableAuthRequiredButtons(){["addQuestionsBtn","startBtn","pauseBtn","resumeBtn","stopBtn","retryFailedBtn","exportBtn","clearAllBtn"].forEach(e=>{const t=document.getElementById(e);t&&(t.disabled=!0,t.style.opacity="0.5",t.style.cursor="not-allowed")});const e=document.getElementById("questionsInput");e&&(e.disabled=!0,e.style.opacity="0.5"),useTempChatCheckbox&&(useTempChatCheckbox.disabled=!0,useTempChatCheckbox.style.opacity="0.5",useTempChatCheckbox.style.cursor="not-allowed"),useWebSearchCheckbox&&(useWebSearchCheckbox.disabled=!0,useWebSearchCheckbox.style.opacity="0.5",useWebSearchCheckbox.style.cursor="not-allowed")}function requireAuth(e){return authManager.isAuthenticated()?(e&&e(),!0):(showLoginModal(),!1)}document.getElementById("loginBtn")?.addEventListener("click",async()=>{const e=document.getElementById("loginEmail").value.trim(),s=document.getElementById("loginPassword").value,n=document.getElementById("loginError"),o=document.getElementById("loginBtn");if(!e||!e.includes("@"))return n.textContent=t("login.invalidEmail"),void(n.style.display="block");if(!s||s.length<6)return n.textContent=t("login.passwordTooShort"),void(n.style.display="block");try{n.style.display="none",o.disabled=!0,o.textContent=t("login.loggingIn"),await authManager.login(e,s),hideLoginModal(),updateUIForAuthState(!0),addLog(t("login.loginSuccess"),"success")}catch(e){n.textContent=t("login.loginFailed")+": "+e.message,n.style.display="block"}finally{o.disabled=!1,o.innerHTML=`<span data-i18n="login.loginBtn">${t("login.loginBtn")}</span>`}}),document.getElementById("registerBtn")?.addEventListener("click",async()=>{const e=document.getElementById("registerEmail").value.trim(),s=document.getElementById("registerPassword").value,n=document.getElementById("registerPasswordConfirm").value,o=document.getElementById("registerError"),a=document.getElementById("registerBtn");if(!e||!e.includes("@"))return o.textContent=t("login.invalidEmail"),void(o.style.display="block");if(!s||s.length<6)return o.textContent=t("login.passwordTooShort"),void(o.style.display="block");if(s!==n)return o.textContent=t("registerPasswordMismatch"),void(o.style.display="block");try{o.style.display="none",a.disabled=!0,a.textContent=t("login.registering"),await authManager.register(e,s),document.getElementById("registerEmail").value="",document.getElementById("registerPassword").value="",document.getElementById("registerPasswordConfirm").value="",hideRegisterModal(),showLoginModal();const n=document.getElementById("loginError");n.style.color="#10b981",n.textContent=t("login.registerSuccess"),n.style.display="block",document.getElementById("loginEmail").value=e}catch(e){o.style.color="#ef4444",o.textContent=t("login.registerFailed")+": "+e.message,o.style.display="block"}finally{a.disabled=!1,a.innerHTML=`<span data-i18n="loginRegisterBtn">${t("login.registerBtn")}</span>`}}),document.getElementById("loginStatusBtn")?.addEventListener("click",()=>{showLoginModal()}),document.getElementById("registerStatusBtn")?.addEventListener("click",()=>{showRegisterModal()}),document.getElementById("cancelRegisterBtn")?.addEventListener("click",()=>{hideRegisterModal(),showLoginModal()}),document.getElementById("goToRegisterBtn")?.addEventListener("click",()=>{hideLoginModal(),showRegisterModal()}),document.getElementById("closeLoginBtn")?.addEventListener("click",()=>{hideLoginModal()}),document.getElementById("closeRegisterBtn")?.addEventListener("click",()=>{hideRegisterModal()});const userMenuBtn=document.getElementById("userMenuBtn"),userDropdownMenu=document.getElementById("userDropdownMenu");async function initializeApp(){const e=await authManager.init();updateUIForAuthState(e),await loadTempChatSetting(),await loadWebSearchSetting(),e?addLog(t("messages.ready"),"success"):addLog("👋 "+t("header.guestMode"),"info")}userMenuBtn?.addEventListener("click",e=>{e.stopPropagation();"block"===userDropdownMenu.style.display?(userDropdownMenu.style.display="none",userMenuBtn.classList.remove("active")):(userDropdownMenu.style.display="block",userMenuBtn.classList.add("active"))}),document.addEventListener("click",e=>{userDropdownMenu&&"block"===userDropdownMenu.style.display&&(userDropdownMenu.contains(e.target)||e.target===userMenuBtn||(userDropdownMenu.style.display="none",userMenuBtn?.classList.remove("active")))}),document.getElementById("logoutBtn")?.addEventListener("click",async()=>{userDropdownMenu&&(userDropdownMenu.style.display="none",userMenuBtn?.classList.remove("active")),await authManager.logout(),updateUIForAuthState(!1),addLog("Logged out","info")}),initializeApp();